<!doctype html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>TravEdu Indonesia - Food Culinary</title>
    
    <script src="https://cdn.tailwindcss.com"></script>
    <script defer src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet" />
    
    <style>
      :root {
        --bg-primary: #ffffff;
        --bg-secondary: #f3f4f6;
        --text-primary: #111827;
        --text-secondary: #4b5563;
        --border-color: #e5e7eb;
        --nav-bg: rgba(255, 255, 255, 0.95);
      }

      html.dark-mode {
        --bg-primary: #000000;
        --bg-secondary: #1c1212;
        --text-primary: #f1f5f9;
        --text-secondary: #cbd5e1;
        --border-color: #252534;
        --nav-bg: rgba(21, 24, 29, 0.95);
      }

      body {
        background-color: var(--bg-primary);
        color: var(--text-primary);
        transition: background-color 0.3s ease, color 0.3s ease;
      }

      .hamburger-line {
        display: block;
        width: 20px;
        height: 2px;
        background-color: var(--text-primary);
        transition: 0.3s;
        border-radius: 2px;
      }

      [x-cloak] { display: none !important; }

      .no-scrollbar::-webkit-scrollbar { display: none; }
      .no-scrollbar { -ms-overflow-style: none; scrollbar-width: none; }

      .theme-toggle {
        position: relative;
        width: 50px;
        height: 28px;
        background-color: #cbd5e1;
        border-radius: 20px;
        cursor: pointer;
        display: flex;
        align-items: center;
        padding: 0 5px;
        transition: 0.3s;
      }
      html.dark-mode .theme-toggle { background-color: #334155; }
      .theme-toggle::after {
        content: '';
        position: absolute;
        left: 3px;
        width: 22px;
        height: 22px;
        background: white;
        border-radius: 50%;
        transition: 0.3s;
      }
      html.dark-mode .theme-toggle::after { left: 25px; }
      
      .category-pill.active {
        background-color: #dc2626 !important;
        color: white !important;
        box-shadow: 0 4px 12px rgba(220, 38, 38, 0.3);
        border-color: #dc2626;
      }

      @keyframes spin-slow { from { transform: rotate(0deg); } to { transform: rotate(360deg); } }
      .animate-spin-slow { animation: spin-slow 3s linear infinite; }
    </style>
  </head>
  <body class="font-sans overflow-x-hidden pt-16">

    <div id="loading-overlay" class="fixed inset-0 z-[9999] bg-[#050505] flex flex-col items-center justify-center transition-all duration-700">
        <div class="absolute w-64 h-64 bg-red-600/20 rounded-full blur-[100px]"></div>
        <div class="relative flex items-center justify-center w-32 h-32 mb-8">
            <div class="absolute inset-0 border-2 border-dashed border-red-600/30 rounded-full animate-spin-slow"></div>
            <div class="z-10 text-4xl font-black text-white italic">T<span class="text-red-600">E</span></div>
        </div>
        <div class="w-48 h-1 bg-gray-800 rounded-full overflow-hidden">
            <div id="progress-bar" class="h-full bg-red-600 w-0 transition-all duration-300"></div>
        </div>
    </div>

    <nav x-data="{ mobileMenu: false, searchOpen: false }" 
         class="fixed top-0 w-full z-50 backdrop-blur-md border-b transition-colors duration-300"
         style="background-color: var(--nav-bg); border-color: var(--border-color);">
      
      <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between items-center h-16">
          
          <div class="flex items-center space-x-8">
            <div class="flex-shrink-0">
              <a href="#" class="text-xl md:text-2xl font-bold italic tracking-tighter" style="color: var(--text-primary);">
                Trav <span class="text-red-600">Edu</span>
              </a>
            </div>

            <div class="hidden md:flex items-center space-x-6">
              <a href="index.html" class="text-sm font-semibold hover:text-red-600 transition" style="color: var(--text-primary);">Beranda</a>
              <a href="index.html" class="text-sm font-semibold hover:text-red-600 transition" style="color: var(--text-primary);">Tentang</a>
              <a href="Festival.html" class="text-sm font-semibold hover:text-red-600 transition" style="color: var(--text-primary);">Festival</a>
              <a href="KulinerSection.html" class="text-sm font-semibold hover:text-red-600 transition" style="color: var(--text-primary);">Kuliner</a>
            </div>
          </div>

          <div class="flex items-center space-x-2 md:space-x-4">
            
            <div class="flex items-center space-x-1.5 bg-gray-900 text-white px-2 py-1 rounded-md border border-gray-700 scale-90 sm:scale-100">
              <i class="fas fa-clock text-red-500 text-[10px]"></i>
              <div class="font-mono text-[11px] md:text-xs font-bold tabular-nums tracking-wider">
                <span id="hours">00</span>:<span id="minutes">00</span>:<span id="seconds">00</span>
              </div>
            </div>

            <button @click="searchOpen = !searchOpen" class="p-2 hover:text-red-600 transition focus:outline-none" style="color: var(--text-primary);">
              <i class="fas fa-search text-sm"></i>
            </button>

            <div id="theme-toggle" class="theme-toggle scale-90 sm:scale-100">
              <i class="fas fa-sun text-[9px] text-yellow-500 absolute left-1.5"></i>
              <i class="fas fa-moon text-[9px] text-blue-300 absolute right-1.5"></i>
            </div>

            <button @click="mobileMenu = !mobileMenu" class="md:hidden flex flex-col space-y-1.5 p-2 ml-1 focus:outline-none">
              <span class="hamburger-line" :class="mobileMenu ? 'rotate-45 translate-y-2' : ''"></span>
              <span class="hamburger-line" :class="mobileMenu ? 'opacity-0' : ''"></span>
              <span class="hamburger-line" :class="mobileMenu ? '-rotate-45 -translate-y-1.5' : ''"></span>
            </button>

            <a href="Contact.html" class="hidden md:block bg-red-600 text-white px-4 py-2 rounded-lg font-bold hover:bg-red-700 shadow-lg transition text-xs uppercase tracking-wider">
              Contact
            </a>
          </div>
        </div>
      </div>

      <div x-show="searchOpen" x-cloak 
           x-transition:enter="transition ease-out duration-300"
           x-transition:enter-start="-translate-y-full opacity-0"
           x-transition:enter-end="translate-y-0 opacity-100"
           class="absolute top-16 left-0 w-full p-4 border-b z-40 shadow-xl"
           style="background-color: var(--bg-secondary); border-color: var(--border-color);">
        <div class="max-w-3xl mx-auto flex items-center bg-white dark:bg-zinc-900 rounded-xl px-4 py-3 border dark:border-zinc-800 shadow-inner">
          <i class="fas fa-search text-red-600 mr-3"></i>
          <input type="text" placeholder="Cari kota atau destinasi..." class="w-full bg-transparent outline-none text-sm md:text-base" style="color: var(--text-primary);">
          <button @click="searchOpen = false" class="text-gray-400 hover:text-red-600 ml-2"><i class="fas fa-times"></i></button>
        </div>
      </div>

      <div x-show="mobileMenu" x-cloak @click.away="mobileMenu = false" 
           class="md:hidden border-t overflow-hidden" 
           style="background-color: var(--nav-bg); border-color: var(--border-color);">
        <div class="px-6 py-8 flex flex-col space-y-5">
          <a href="index.html" class="text-lg font-bold" style="color: var(--text-primary);">Beranda</a>
          <a href="index.html" class="text-lg font-bold" style="color: var(--text-primary);">Tentang</a>
          <a href="Festival.html" class="text-lg font-bold" style="color: var(--text-primary);">Festival</a>
          <a href="KulinerSection.html" class="text-lg font-bold" style="color: var(--text-primary);">Kuliner</a>
          <a href="Contact.html" class="bg-red-600 text-white text-center py-4 rounded-xl font-bold uppercase tracking-widest shadow-lg">Hubungi Kami</a>
        </div>
      </div>
    </nav>

    <div
      id="search-container"
      class="fixed top-16 left-0 right-0 z-40 backdrop-blur-lg max-h-0 overflow-hidden transition-all duration-300 shadow-sm"
      style="background: linear-gradient(to right, var(--bg-primary), var(--bg-secondary), var(--bg-primary)); border-bottom: 1px solid var(--border-color);"
    >
      <div class="flex flex-col items-stretch px-4 sm:px-8 py-6 max-w-7xl mx-auto">
        <div class="flex items-center">
          <i class="fas fa-search text-red-600 mr-4 text-lg flex-shrink-0"></i>
          <input
            type="text"
            placeholder="Search city or destination..."
            class="w-full outline-none text-lg transition-colors duration-300 focus:ring-0 py-3 input-focus"
            style="background-color: var(--input-bg); color: var(--text-primary); border-bottom: 2px solid var(--input-border);"
            data-i18n-placeholder="placeholder_search"
          />
          <button
            id="close-search"
            class="p-2 transition-colors duration-300 ml-4 flex-shrink-0 hover-red"
            style="color: var(--text-secondary);"
          >
            <i class="fas fa-times text-2xl"></i>
          </button>
        </div>
        
        <div id="search-suggestions" class="mt-4 space-y-2"></div>
      </div>
    </div>



    <header class="py-16 px-6 text-center">
      <h2 class="text-4xl md:text-5xl font-extrabold mb-4" style="color: var(--text-primary);">
        Jelajahi Kekayaan Kuliner Indonesia
      </h2>
      <p class="text-lg max-w-2xl mx-auto" style="color: var(--text-secondary);">
        Temukan makanan dan minuman otentik dari berbagai daerah di Indonesia.
      </p>
    </header>

    <section class="container mx-auto px-6 py-8">
  <div class="relative group">
    <div class="absolute left-0 top-0 bottom-0 w-12 z-10 bg-gradient-to-r from-white via-white/50 to-transparent pointer-events-none opacity-0 group-hover:opacity-100 transition-opacity duration-300 md:hidden block"></div>
    
    <div  
      class="flex overflow-x-auto md:overflow-visible pb-4 mb-8 gap-3 no-scrollbar scroll-smooth md:flex-wrap md:justify-center items-center"
      id="filter-buttons"
    >
      <button
        onclick="filterSelection('semua')"
        class="category-pill active flex-none px-6 py-2 rounded-full border border-red-500 font-medium transition-all duration-300 whitespace-nowrap"
      >
        Semua
      </button>
      
      <button onclick="filterSelection('Bali')" class="category-pill flex-none px-6 py-2 rounded-full border border-red-500 text-red-500 hover:bg-red-500 hover:text-white transition-all duration-300 whitespace-nowrap">Bali</button>
      <button onclick="filterSelection('Jogja')" class="category-pill flex-none px-6 py-2 rounded-full border border-red-500 text-red-500 hover:bg-red-500 hover:text-white transition-all duration-300 whitespace-nowrap">Jogja</button>
      <button onclick="filterSelection('Jakarta')" class="category-pill flex-none px-6 py-2 rounded-full border border-red-500 text-red-500 hover:bg-red-500 hover:text-white transition-all duration-300 whitespace-nowrap">Jakarta</button>
      <button onclick="filterSelection('Malang')" class="category-pill flex-none px-6 py-2 rounded-full border border-red-500 text-red-500 hover:bg-red-500 hover:text-white transition-all duration-300 whitespace-nowrap">Malang</button>
      <button onclick="filterSelection('Bandung')" class="category-pill flex-none px-6 py-2 rounded-full border border-red-500 text-red-500 hover:bg-red-500 hover:text-white transition-all duration-300 whitespace-nowrap">Bandung</button>
      <button onclick="filterSelection('Makassar')" class="category-pill flex-none px-6 py-2 rounded-full border border-red-500 text-red-500 hover:bg-red-500 hover:text-white transition-all duration-300 whitespace-nowrap">Makassar</button>
      <button onclick="filterSelection('Manado')" class="category-pill flex-none px-6 py-2 rounded-full border border-red-500 text-red-500 hover:bg-red-500 hover:text-white transition-all duration-300 whitespace-nowrap">Manado</button>
      <button onclick="filterSelection('Balikpapan')" class="category-pill flex-none px-6 py-2 rounded-full border border-red-500 text-red-500 hover:bg-red-500 hover:text-white transition-all duration-300 whitespace-nowrap">Balikpapan</button>
      <button onclick="filterSelection('Pontianak')" class="category-pill flex-none px-6 py-2 rounded-full border border-red-500 text-red-500 hover:bg-red-500 hover:text-white transition-all duration-300 whitespace-nowrap">Pontianak</button>
      <button onclick="filterSelection('Medan')" class="category-pill flex-none px-6 py-2 rounded-full border border-red-500 text-red-500 hover:bg-red-500 hover:text-white transition-all duration-300 whitespace-nowrap">Medan</button>
      <button onclick="filterSelection('Palembang')" class="category-pill flex-none px-6 py-2 rounded-full border border-red-500 text-red-500 hover:bg-red-500 hover:text-white transition-all duration-300 whitespace-nowrap">Palembang</button>
      <button onclick="filterSelection('Padang')" class="category-pill flex-none px-6 py-2 rounded-full border border-red-500 text-red-500 hover:bg-red-500 hover:text-white transition-all duration-300 whitespace-nowrap">Padang</button>
      <button onclick="filterSelection('Jayapura')" class="category-pill flex-none px-6 py-2 rounded-full border border-red-500 text-red-500 hover:bg-red-500 hover:text-white transition-all duration-300 whitespace-nowrap">Jayapura</button>
      <button onclick="filterSelection('Mataram')" class="category-pill flex-none px-6 py-2 rounded-full border border-red-500 text-red-500 hover:bg-red-500 hover:text-white transition-all duration-300 whitespace-nowrap">Mataram</button>
      <button onclick="filterSelection('Kupang')" class="category-pill flex-none px-6 py-2 rounded-full border border-red-500 text-red-500 hover:bg-red-500 hover:text-white transition-all duration-300 whitespace-nowrap">Kupang</button>
      <button onclick="filterSelection('Ambon')" class="category-pill flex-none px-6 py-2 rounded-full border border-red-500 text-red-500 hover:bg-red-500 hover:text-white transition-all duration-300 whitespace-nowrap">Ambon</button>
    </div>

    <div class="absolute right-0 top-0 bottom-0 w-16 z-10 bg-gradient-to-l from-white via-white/80 to-transparent pointer-events-none md:hidden block"></div>
  </div>

  <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8" id="menu-container">
    </div>
</section>


    <script>
      // 1. Loading Animation
      window.addEventListener('load', () => {
          const progressBar = document.getElementById('progress-bar');
          const loader = document.getElementById('loading-overlay');
          let progress = 0;
          const interval = setInterval(() => {
              progress += Math.random() * 30; 
              if (progress > 100) progress = 100;
              progressBar.style.width = `${progress}%`;
              if (progress >= 100) {
                  clearInterval(interval);
                  setTimeout(() => {
                      loader.style.opacity = '0';
                      setTimeout(() => loader.style.display = 'none', 700);
                  }, 500);
              }
          }, 150);
      });

      // 2. Dark Mode Toggle (DIUBAH ID NYA AGAR SESUAI)
      const themeBtn = document.getElementById('theme-toggle');
      if(themeBtn) {
          themeBtn.addEventListener('click', () => {
              document.documentElement.classList.toggle('dark-mode');
              const isDark = document.documentElement.classList.contains('dark-mode');
              localStorage.setItem('theme', isDark ? 'dark' : 'light');
          });
      }

      if (localStorage.getItem('theme') === 'dark') {
          document.documentElement.classList.add('dark-mode');
      }

      // 3. Clock Logic (FIXED & TESTED)
      function updateClock() {
          const now = new Date();
          const h = String(now.getHours()).padStart(2, '0');
          const m = String(now.getMinutes()).padStart(2, '0');
          const s = String(now.getSeconds()).padStart(2, '0');
          
          const hEl = document.getElementById('hours');
          const mEl = document.getElementById('minutes');
          const sEl = document.getElementById('seconds');

          if(hEl && mEl && sEl) {
              hEl.textContent = h;
              mEl.textContent = m;
              sEl.textContent = s;
          }
      }
      setInterval(updateClock, 1000);
      updateClock();

      // 4. Filter Selection Handler
      function filterSelection(c, event) {
          const pills = document.querySelectorAll('.category-pill');
          pills.forEach(pill => pill.classList.remove('active'));
          
          if(event) {
              event.currentTarget.classList.add('active');
          }
          
          // Memastikan fungsi di Kuliner.js terpanggil
          if (window.renderMenu) {
              window.renderMenu(c);
          } else {
              console.warn("Fungsi renderMenu belum dimuat dari Kuliner.js");
          }
      }

      function closeModal() {
          document.getElementById('detail-modal').classList.add('hidden');
      }
    </script>
    
    <script src="../js/Kuliner.js"></script>
  </body>
</html>